 package gov.va.med.mhv.health.validator;

import gov.va.med.mhv.health.dto.MilitaryHistoryDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import org.springframework.stereotype.Component;

@Component
public class MilitaryHistoryValidator extends Validator{
	private static final String TITLE="Title";
	private static final String EXPOSURES="Exposures";
	private static final String EXPERIENCE="Military Service";
	
	public void militaryHistoryValidations(ResponseUtil response, MilitaryHistoryDTO militaryHistoryDTO) 
	{
		validateTitle(response, militaryHistoryDTO);
		validateExposuresAndService(response, militaryHistoryDTO);
	}

	public void validateTitle(ResponseUtil response, MilitaryHistoryDTO militaryHistoryDTO) 
	{  
		String title = militaryHistoryDTO.getEventTitle();
		if (title == null || isEmpty(title.trim())) 
		{
			response.getValidationErrors().put(TITLE, "Title is a required field.");
		}
	}
		
	public void validateExposuresAndService(ResponseUtil response, MilitaryHistoryDTO militaryHistoryDTO) {       
		
		String exposures = militaryHistoryDTO.getExposures();
		String experience = militaryHistoryDTO.getExperience();		
		
        if (exposures == null || isEmpty(exposures.trim())) 
        {
        	response.getValidationErrors().put(EXPOSURES, "Exposures is a required field.");  
        }
        
        if (experience == null || isEmpty(experience.trim())) 
        {       		
    		response.getValidationErrors().put(EXPERIENCE, "Military Service is a required field.");
    	}
    	
	}
	
	public boolean isEmpty(String s) 
	{
		return (s == null || s.equals("")) ? true : false;
	}
	
}
